<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class DatabaseBackUp extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'database:backup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // Set the database credentials.
        $dbHost = env('DB_HOST');
        $dbPort = env('DB_PORT');
        $dbName = env('DB_DATABASE');
        $dbUser = env('DB_USERNAME');
        $dbPass = env('DB_PASSWORD');

        // Set the backup filename and location.
        $filename = 'backup-' . date('Y-m-d-H-i-s') . '.sql';
        $backupLocation = storage_path('app/backup/' . $filename);

        // Create the backup command.
        $command = "mysqldump --host={$dbHost} --port={$dbPort} --user={$dbUser} --password='{$dbPass}' {$dbName} > {$backupLocation}";

        // Execute the backup command.
        $returnVar = null;
        $output = null;
        exec($command, $output, $returnVar);

        // Check if the backup was successful.
        if ($returnVar === 0) {
            // Display success message.
            $this->info('Database backup created successfully!');
            $this->info('Backup location: ' . $backupLocation);
        } else {
            // Display error message.
            $this->error('Database backup failed!');
            $this->error('Error code: ' . $returnVar);
            $this->error('Error output: ' . implode("\n", $output));
        }
    }
}
