<?php

namespace App\Exports;

use App\Models\DuplicateProduct;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class RejectedStockExport implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $products = DuplicateProduct::select("barcode","product","category","buying", "supplier", "location","minunit","mincont","minqty","qty","exp","expnot",  "unit1", "unitcont1", "selling1", "unit2", "unitcont2", "selling2", "unit3", "unitcont3", "selling3")->get();
        return $products;
    }

    public function headings(): array {

        return [
            "BARCODE",
            "PRODUCT",
            "CATEGORY",
            "BUYING",
            "SUPPLIER",
            "LOCATION",
            "MINUNIT",
            "MINCONT",
            "MINQTY",
            "QTY",
            "EXP DATE",
            "EXP NOT",
            "UNIT1",
            "CONT1",
            "SELLING1",
            "UNIT2",
            "CONT2",
            "SELLING2",
            "UNIT3",
            "CONT3",
            "SELLING3",
        ];
    }
}
