<?php

namespace App\Exports;

use App\Models\Product;
use App\Models\ProductCategory;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Http\Request;

class StocktackingExport implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */


    protected $request;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    public function collection()
    {

        $category = ProductCategory::where("name", "Menu")->first();
        $stocks = Product::select("product")
        ->where("category_id", "!=", $category->id)
        ->get();

        return $stocks;
    }

     public function headings(): array {

        return [
            "PRODUCT",
            "NEW QTY",
        ];
    }
}
