<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Product;
use App\Models\ProductCategory;
use Illuminate\Http\Request;

class ProductController extends Controller
{
    public function getQRProducts(Request $request)
    {
        $locationId = $request->location_id; // optional filter by location

        // Get all category IDs under parent_id = 1 & 2
        $categories = ProductCategory::whereIn('parent_id', [1, 2])->get();

        $categoryIds = $categories->pluck('id')->toArray();

        $products = Product::with(['unit.unit', 'stock.unit', 'category'])
            ->whereIn('category_id', $categoryIds)
            ->when($locationId, fn($q) => $q->where('location_id', $locationId))
            ->get()
            ->map(function ($product) {
                $unit = $product->unit->first(); // choose appropriate unit if multiple
                $stock = $product->stock->first();

                return [
                    'product_id' => $product->id,
                    'name'       => $product->product,
                    'description' => $product->description ?? '',
                    'category'   => $product->category->name ?? 'Uncategorized',
                    'price'      => $unit?->selling ?? 0,
                    'qty'        => $stock?->qty ?? 0,
                    'unit'       => $unit?->unit_id ?? 0,
                    'image'      =>  asset('storage/images/' . $product->image), // if you want image
                ];
            });

        return response()->json([
            'success' => true,
            'products' => $products,
            'categories' => $categories->map(function ($category) {
                return [
                    'id' => $category->id,
                    'name' => $category->name,
                ];
            }),
        ]);
    }
}
