<?php

namespace App\Http\Controllers;

use App\Models\Account;
use App\Models\Customer;
use App\Models\CustomerOrder;
use App\Models\CustomerOrderItem;
use App\Models\PostExpense;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CustomerOrderController extends Controller
{
    public function index()
    {
        try {
            $accounts = Account::all();
            $customerOrders = CustomerOrder::with('customer', 'user', 'orderItems', 'account')->get();
            return view('customer-order', compact('customerOrders', 'accounts'));
        } catch (\Exception $e) {
            return response()->json([
                'error' => 'Something went wrong',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    public function newCustomerOrder($flag, $id)
    {
        try {
            if ($flag == 2) {
                $orderDetails = CustomerOrder::find($id);
                $orderItems = CustomerOrderItem::where('customer_order_id', $id)->get();
                // Add the two variables to their respective sessions
                session(['orderDetails' => $orderDetails]);
                session(['orderItems' => $orderItems]);
            }

            $accounts = Account::all();
            $customers = Customer::all();
            $customerOrders = CustomerOrder::with(
                'customer',
                'user',
                'orderItems',
                'account',
            )->get();
            return view('new-customer-order', compact(
                'customerOrders',
                'accounts',
                'customers',
                'flag',
                'id'
            ));
        } catch (\Exception $e) {
            return response()->json([
                'error' => 'Something went wrong',
                'message' => $e->getMessage()
            ], 500);
        }
    }
    public function store(Request $request, $flag, $id)
    {
        DB::beginTransaction();
        try {
            if ($flag == 2) {
                $customerOrder = CustomerOrder::find($id);
                $customerOrder->date = $request->input('date');
                $customerOrder->customer_id = $request->input('customer');
                $customerOrder->user_id = auth()->user()->id;
                $customerOrder->total_buying = $request->input('total-buying');
                $customerOrder->total_selling = $request->input('total-selling');
                $customerOrder->total_profit = $request->input('total-profit');
                $customerOrder->paid = $request->input('paid');
                $customerOrder->due = $request->input('due');
                $customerOrder->status = $request->input('due') <= 0 ? 'Cleared' : 'Pending';
                $customerOrder->account_id = $request->input('account');
                $customerOrder->update();

                $orderItems = CustomerOrderItem::where('customer_order_id', $id)->delete();

                for ($i = 0; $i < count($request->input('product')); $i++) {
                    $orderItems = new CustomerOrderItem();
                    $orderItems->customer_order_id = $customerOrder->id;
                    $orderItems->product = $request->input('product')[$i];
                    $orderItems->buying_price = $request->input('buyin_price')[$i];
                    $orderItems->selling_price = $request->input('selling_price')[$i];
                    $orderItems->qty = $request->input('qty')[$i];
                    $orderItems->save();
                }
            } else {
                $customerOrder = new CustomerOrder();
                $customerOrder->date = $request->input('date');
                $customerOrder->customer_id = $request->input('customer');
                $customerOrder->user_id = auth()->user()->id;
                $customerOrder->total_buying = $request->input('total-buying');
                $customerOrder->total_selling = $request->input('total-selling');
                $customerOrder->total_profit = $request->input('total-profit');
                $customerOrder->paid = $request->input('paid');
                $customerOrder->due = $request->input('due');
                $customerOrder->status = $request->input('due') <= 0 ? 'Cleared' : 'Pending';
                $customerOrder->account_id = $request->input('account');
                $customerOrder->save();

                for ($i = 0; $i < count($request->input('product')); $i++) {
                    $orderItems = new CustomerOrderItem();
                    $orderItems->customer_order_id = $customerOrder->id;
                    $orderItems->product = $request->input('product')[$i];
                    $orderItems->buying_price = $request->input('buying_price')[$i];
                    $orderItems->selling_price = $request->input('selling_price')[$i];
                    $orderItems->qty = $request->input('qty')[$i];
                    $orderItems->save();
                }
            }

            $account = Account::find($request->input('account'));
            $account->balance += $request->input('total-selling');
            $account->update();

            $transaction = new Transaction();
            $transaction->date = $request->input('date');
            $transaction->reason = 'Customer Order';
            $transaction->status = 'In';
            $transaction->amount = $request->input('total-selling');
            $transaction->before = $account->balance;
            $transaction->after = $account->balance + $request->input('total-selling');
            $transaction->account_id = $request->input('account');
            $transaction->user_id = auth()->user()->id;
            $transaction->location_id = 2;
            $transaction->save();

            DB::commit();
            return redirect()->route('customer.order.index')->with('success', 'Order created successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'error' => 'Something went wrong',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    public function destroy(Request $request)
    {
        DB::beginTransaction();
        try {
            $orderId = $request->id;
            CustomerOrder::find($orderId)->delete();
            DB::commit();
            return back();
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'error' => 'Something went wrong',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    public function profitAndLoss(Request $request)
    {
        # Initiate varibales
        $currentDate = date('Y-m-d');
        $type = $request->type;
        $start = $request->start ? $request->start : $currentDate;
        $end = $request->end ? $request->end : $currentDate;
        $totalrevenue = 0;
        $cogs = 0;
        $totalExpenditure = 0;
        $netProfit = 0;

        if ($type) {
            # Initiate query
            $customerOrderQuery = CustomerOrder::query();
            $expenseQuery = PostExpense::where('status', 1);

            if ($type == "today") {
                $customerOrderQuery->where('date', $currentDate);
                $expenseQuery->where('date', $currentDate);
            } elseif ($type == "set date") {
                $customerOrderQuery->where('date', $start);
                $expenseQuery->where('date', $start);
            } elseif ($type == "set duration") {
                $customerOrderQuery->whereBetween('date', [$start, $end]);
                $expenseQuery->whereBetween('date', [$start, $end]);
            }

            $totalrevenue = $customerOrderQuery->sum('total_selling');
            $cogs = $customerOrderQuery->sum('total_buying');
            $totalExpenditure = $expenseQuery->sum('sum');
            $netProfit = $totalrevenue - $cogs - $totalExpenditure;
        }

        return view('customer-order-profit-and-loss', compact(
            'totalrevenue',
            'totalExpenditure',
            'cogs',
            'netProfit',
            'type',
            'start',
            'end'
        ));
    }

    public function CustomerOrderPayment(Request $request, $id)
    {
        //dd($request->input('amount-paid'));
        try {
            DB::beginTransaction();
            $customerOrder = CustomerOrder::find($id);
            $customerOrder->paid += $request->input('amount-paid');
            $customerOrder->due -= $request->input('amount-paid');
            $customerOrder->status = $request->input('amount-paid') >= $request->input('amount-due') ? 'Cleared' : 'Pending';
            $customerOrder->update();

            $account = Account::find($request->input('account'));
            $account->balance += $request->input('amount-paid');
            $account->update();

            $transaction = new Transaction();
            $transaction->date = $request->input('date');
            $transaction->reason = 'Customer Order payment';
            $transaction->status = 'In';
            $transaction->amount = $request->input('amount-paid');
            $transaction->before = $account->balance;
            $transaction->after = $account->balance + $request->input('amount-paid');
            $transaction->account_id = $request->input('account');
            $transaction->user_id = auth()->user()->id;
            $transaction->location_id = 2;
            $transaction->save();

            DB::commit();

            return back()->with("success", "Payment successfully posted.");
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }
}
