<?php

namespace App\Http\Controllers;

use App\Models\Debtor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DebtorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        # Get location details
        $locationDetails = processLocationDetails();
        $sellingCount = $locationDetails['sellingCount'];
        $sellings = $locationDetails['sellings'];
        $debtors = $locationDetails['debtors'];

        return view('debtors', compact(
            "debtors",
            "sellingCount",
            "sellings",
        ));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        DB::beginTransaction();
        try {
            $debtor = new Debtor();
            $debtor->name = $request->input('name');
            $debtor->address = $request->input('address');
            $debtor->phone = $request->input('phone');
            $debtor->location_id = $request->input('location');
            $debtor->save();

            DB::commit();

            return redirect()->back()->with('success', 'Successfully added new debtor.');
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json(['error' => 'An error occurred while registering debtor.']);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        DB::beginTransaction();
        try {
            $debtor = Debtor::find($id);
            $debtor->name = $request->input('name');
            $debtor->address = $request->input('address');
            $debtor->phone = $request->input('phone');
            $debtor->location_id = $request->input('location');
            $debtor->update();

            DB::commit();

            return redirect()->back()->with('success', 'Successfully updated.');
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json(['error' => 'An error occurred while updating debtor.']);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        DB::beginTransaction();

        try {
            Debtor::destroy($id);
            DB::commit();
            return redirect()->back()->with("success", "Successfully deleted!!");
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['error' => 'An error occurred while deleting debtor']);
        }
    }
}
