<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\Payment;

class DpoController extends Controller
{
    /**
     * Initiate a DPO payment
     */
    public function initiatePayment(Request $req)
    {
        // Validate the incoming request
        $req->validate([
            'amount' => 'required|numeric|min:1',
        ]);

        $amount = $req->input('amount');
        $callbackUrl = route('dpo.callback');

        // Call DPO API
        $response = Http::post('https://api.dpo.example/create', [
            'CompanyToken' => env('DPO_TOKEN'),
            'ServiceType'  => env('DPO_SERVICE_TYPE'),
            'Amount'       => $amount,
            'Currency'     => env('DPO_CURRENCY'),
            'CallbackURL'  => $callbackUrl,
            'ReturnURL'    => $callbackUrl,
            'Description'  => 'Subscription Payment',
        ]);

        $data = $response->json();

        // Handle API error
        if (!isset($data['payment_url'])) {
            return redirect()->back()->with('error', 'Failed to initiate payment. Try again.');
        }

        // Redirect user to DPO payment page
        return redirect($data['payment_url']);
    }

    /**
     * Handle DPO payment callback
     */
    public function paymentCallback(Request $req)
    {
        // Basic verification (you can enhance with signature verification)
        if ($req->input('status') === 'success') {

            // Store payment in DB
            Payment::create([
                'user_id'        => auth()->id(),
                'payment_method' => $req->input('method'), // e.g. mpesa, card
                'amount'         => (float) $req->input('amount'),
                'transaction_id' => $req->input('trans_id'),
                'status'         => 'completed',
                'response'       => json_encode($req->all()), // raw DPO response
            ]);

            // TODO: Activate user subscription or features

            return view('payment.success')->with('message', 'Payment successful! Thank you.');
        }

        // Failed payment
        return view('payment.failed')->with('message', 'Payment failed or canceled.');
    }
}
