<?php

namespace App\Http\Controllers;

use App\Models\Driver;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class DriverController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {
            $drivers = Driver::all();
            return view("driver", compact("drivers"));
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        DB::beginTransaction();

        try {
            $driver = new Driver();
            $driver->name = ucwords($request->name);
            $driver->address = ucwords($request->address);
            $driver->phone = $request->phone;
            $driver->save();

            DB::commit();

            return back()->with("success", "Successfully added!!");
        } catch (Exception $e) {
            DB::rollBack();

            Log::error($e->getMessage());

            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        DB::beginTransaction();

        try {
            $driver = Driver::findOrFail($id); // Find the driver or fail

            $driver->name = ucwords($request->name);
            $driver->address = ucwords($request->address);
            $driver->phone = $request->phone;
            $driver->save();

            DB::commit();

            return back()->with("success", "Driver updated successfully!!");
        } catch (Exception $e) {
            DB::rollBack();

            Log::error($e->getMessage());

            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        DB::beginTransaction();

        try {
            $driver = Driver::findOrFail($id); // Find the driver or fail

            $driver->delete(); // Delete the driver

            DB::commit();

            return back()->with("success", "Driver deleted successfully!!");
        } catch (Exception $e) {
            DB::rollBack();

            Log::error($e->getMessage());

            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    public function bulkDelete(Request $request)
    {
        DB::beginTransaction();

        try {
            $ids = $request->ids;

            // Use whereIn for bulk delete
            $deleted = Driver::whereIn('id', $ids)->delete();

            DB::commit();

            return response()->json([
                'success' => true,
                'message' => "$deleted drivers deleted successfully!"
            ]);
        } catch (Exception $e) {
            DB::rollBack();

            Log::error($e->getMessage());

            return response()->json([
                'success' => false,
                'error' => 'Something went wrong'
            ], 500);
        }
    }
}
