<?php

namespace App\Http\Controllers;

use App\Models\Game;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class GamesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $games = Game::all();
        return view('games', compact('games'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        DB::beginTransaction();

        //try {
            $game = new Game();
            $game->name = $request->input('name');
            $game->duration = $request->input('duration');
            $game->life_circle = $request->input('life-circle');
            $game->members = $request->input('members');
            $game->p_amount = $request->input('p-amount');
            $game->r_amount = $request->input('r-amount');
            $game->save();

            DB::commit();

            return redirect()->back()->with('success', 'Game created successfully');
        // } catch (\Exception $e) {
        //     DB::rollback();
        //     return redirect()->back()->with('error', 'Something went wrong');
        // }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        DB::beginTransaction();

        try {
            $game = Game::find($id);
            $game->name = $request->input('name');
            $game->duration = $request->input('duration');
            $game->life_circle = $request->input('life-circle');
            $game->no_of_member = $request->input('member');
            $game->p_amount = $request->input('p-amount');
            $game->r_amount = $request->input('r-amount');
            $game->update();

            DB::commit();

            return redirect()->back()->with('success', 'Game updated successfully');
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->back()->with('error', 'Something went wrong');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        DB::beginTransaction();
        try {
            $game = Game::find($id);
            $game->delete();

            DB::commit();

            return redirect()->back()->with('success', 'Game deleted successfully');
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->back()->with('error', 'Something went wrong');
        }
    }

    public function bulkDelete(Request $request)
    {
        try {
            $ids = $request->ids;

            $results = "";

            foreach ($ids as $id) {
                $results = Game::find($id)->delete();
            }
            return response()->json($results);
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }
}
