<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Ip;
use App\Models\License;
use Exception;
use Illuminate\Support\Facades\Log;

class IpController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {
            $ips = Ip::all();
            return view('ip-address', compact('ips'));
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $license = License::latest()->first();
            $ips = Ip::all()->count();

            if (count($request->ip) <= $license->device && $ips <  $license->device) {

                foreach ($request->input('ip') as $key => $value) {

                    Ip::create([
                        'name' => $request->input('ip')[$key],
                    ]);
                }

                return redirect()->back()->with("success", "Successfully added!!");
            }

            return redirect()->back()->with("info", "You can only add " . $license->device . " ip(s)..call 0786 373 296 if you need more");
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $ip = Ip::find($id);
            $ip->name = $request->name;
            $ip->save();

            return back()->with("success", "Successfully updated!!");
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            Ip::find($id)->delete();
            return back()->with("success", "Successfully deleted!!");
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }
}
