<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use thiagoalessio\TesseractOCR\TesseractOCR;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\ArrayExport;

class OcrExcelController extends Controller
{
    public function uploadForm()
    {
        return view('image-to-excel');
    }

    public function extractAndExport(Request $request)
    {
        $request->validate([
            'image' => 'required|image'
        ]);

        // 1. Store image
        $path = $request->file('image')->store('ocr');

        // 2. Extract text using Tesseract with explicit binary path
        $text = (new TesseractOCR(storage_path('app/' . $path)))
            ->executable('C:\Program Files\Tesseract-OCR\tesseract.exe') // full path here
            ->lang('eng')
            ->run();

        // 3. Convert text to array (split by lines)
        $lines = array_filter(array_map('trim', explode("\n", $text)));
        $data = [];
        foreach ($lines as $line) {
            $data[] = preg_split('/\s{2,}|\t/', $line); // split by spaces or tab
        }

        // 4. Export to Excel
        return Excel::download(new ArrayExport($data), 'ocr-table.xlsx');
    }
}
