<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class SessionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // Retrieve the value of the 'row' parameter from the request
        $items = $request->get('row');
        $details = $request->get('details');

        session()->put('sales_details', [$details]);

        // Check if the session variable exists. If not, create it and populate it with the new value
        if (!session()->has('sold_items')) {
            session()->put('sold_items', [$items]);
        } else {
            // Retrieve the current session items
            $session = session()->get('sold_items');
            $iteration = 0; // Initialize the index
            $found = 0; // Initialize the flag to indicate if a matching entry is found

            // Iterate over each entry in the session array
            foreach ($session as $entry) {
                // Check if the name of the current entry matches the name of the incoming items
                if ($entry['index'] === $items['index']) {
                    // Replace the existing items in the session with the new incoming items
                    $session[$iteration] = $items;
                    $found = 1; // Set the flag to indicate a match is found
                    break; // Exit the loop since the update is done
                }

                $iteration++; // Increment the index
            }

            // If no matching entry is found, append the new items to the session array
            if ($found === 0) {
                $session[] = $items;
            }

            // Update the session variable with the modified session array
            session()->put('sold_items', $session);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $deletedIndex = $request->get('index');
        // Retrieve the current data stored in the session with the 'sold_items' key
        $items = session()->get('sold_items', []);

        // Find the index of the item to remove
        $index = array_search($deletedIndex, array_column($items, 'index'));
        // Remove the item from the array if found
        if ($index !== false) {
            unset($items[$index]);
            // Re-index the array keys
            $items = array_values($items);
        }

        // Update the session data with the modified array
        session()->put('sold_items', $items);
        // Save the session
        session()->save();

        $details = $request->get('details');
        // Update sales detail session with the new incoming details.
        session()->put('sales_details', $details);
        // Save the session
        session()->save();

        // Return a response if necessary
        return response()->json(['success' => true]);
            }
}
