<?php

namespace App\Http\Controllers;

use App\Models\Account;
use App\Models\Driver;
use App\Models\LoadedItems;
use App\Models\LoadVehicle;
use App\Models\Location;
use App\Models\Product;
use App\Models\Sale;
use App\Models\Salesmen;
use App\Models\SoldItem;
use App\Models\Stock;
use App\Models\StockMovement;
use App\Models\Transaction;
use App\Models\UnitAssigned;
use App\Models\UnloadedItems;
use App\Models\UnloadVehicle;
use App\Models\Vehicle;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class VehicleController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {
            $vehicles = Location::where('status', 'dynamic')->get();
            return view("vehicle", compact("vehicles"));
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    public function loadView()
    {
        try {
            # Get location details
            $locationDetails = processLocationDetails();
            $sellings = $locationDetails['sellings'];
            $storages = $locationDetails['storages'];

            # Initiate variables
            $drivers = Driver::all();
            $salesmen = Salesmen::all();

            return view("load-vehicle", compact(
                'sellings',
                'storages',
                'drivers',
                'salesmen'
            ));
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    public function unloadView()
    {
        try {
            # Get location details
            $locationDetails = processLocationDetails();
            $sellings = $locationDetails['sellings'];
              $storages = $locationDetails['storages'];
            $accounts = $locationDetails['accounts'];

            return view("unload-vehicle", compact('sellings', 'storages', 'accounts'));
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        // Validate the request
        $validated = $request->validate([
            'name' => 'required|string',
        ]);

        // Insert the location
        $location = Location::create([
            'name'   => $validated['name'],
            'type'   => 'Vehicle', // Or any default type you want
            'status' => 'Active',  // Or any default status
            'owner'  => null,      // Optional
            'phone'  => null,      // Optional
        ]);

        return response()->json([
            'message' => 'Location created successfully!',
            'location' => $location
        ]);
    }


    public function loadVehicleStore(Request $request)
    {
        dd($request->all());

        try {
            # Define load id
            $load_id = null;

            # Get the loaded vehicle
            $loadedvehicle = LoadVehicle::where("vehicle_id", $request->vehicle)
                ->where("salesman_id", $request->salesman)
                ->where("driver_id", $request->driver)
                ->first();

            if ($loadedvehicle) { # If it exists
                # Increment loaded value..
                $loadedvehicle->total += $request->total;
                $loadedvehicle->update();

                # Save loadid..
                $load_id = $loadedvehicle->id;
            } else {

                # If no create new entry..
                $load = new LoadVehicle();

                $load->date = $request->date;
                $load->user_id = auth()->user()->id;
                $load->total = $request->total;
                $load->location_id = $request->location;
                $load->vehicle_id = $request->vehicle;
                $load->driver_id = $request->driver;
                $load->salesman_id = $request->salesman;
                $load->status = "Loaded";
                $load->save();

                # Save load id..
                $load_id = $load->id;
            }

            # Loop throuhg the loaded items
            for ($i = 0; $i < count($request->id); ++$i) {

                # Get the base unit of each item
                $base_unit = UnitAssigned::where("location_id", $request->location)
                    ->where("product_id", $request->id[$i])
                    ->orderBy("unit_cont", "asc")
                    ->first();

                $item = LoadedItems::where("load_vehicle_id", $load_id)
                    ->where("product_id", $request->id[$i])
                    ->first();

                if ($item) { # If it exists
                    $item->qty += $request->qty[$i] *  $request->cont[$i];
                    $item->amount += $request->qty[$i] *  $request->cont[$i] * $base_unit->selling;
                    $item->update();
                } else {
                    # If not create new entry..
                    $item = new LoadedItems();

                    $item->load_vehicle_id = $load_id;
                    $item->product_id = $request->id[$i];
                    $item->unit_id = $base_unit->unit_id;
                    $item->cont = $base_unit->unit_cont;
                    $item->price = $base_unit->selling;
                    $item->qty = $request->qty[$i] *  $request->cont[$i];
                    $item->amount = $request->qty[$i] *  $request->cont[$i] * $base_unit->selling;

                    $item->save();
                }

                $stockIn = Stock::where("location_id", $request->vehicle)
                    ->where("product_id", $request->id[$i])
                    ->first();

                if ($stockIn) { # If it exists

                    # Save stock movement for that specific product in the vehicle..
                    $movement = new StockMovement();

                    $movement->date = $request->date;
                    $movement->user_id = auth()->user()->id;
                    $movement->product_id = $request->id[$i];
                    $movement->reason = "Vehicle Loaded";
                    $movement->status = "In";
                    $movement->qty = $request->qty[$i] * $request->cont[$i];
                    $movement->before = $stockIn->qty;
                    $movement->after =  $stockIn->qty + ($request->qty[$i] * $request->cont[$i]);
                    $movement->location_id = $request->vehicle;

                    $movement->save();

                    # Increment it's qty & amount then update.
                    $stockIn->qty += $request->qty[$i] * $request->cont[$i];
                    $stockIn->update();
                } else {
                    # if no then create it in products table.
                    $oldproduct = Product::where("id", $request->id[$i])
                        ->where("location_id", $request->location)
                        ->first();

                    $newproduct = new Product();

                    $newproduct->barcode = $oldproduct->barcode;
                    $newproduct->product = $request->product[$i];
                    $newproduct->category_id = $oldproduct->category_id;
                    $newproduct->buying = $oldproduct->buying;
                    $newproduct->supplier_id = $oldproduct->supplier_id;
                    $newproduct->location_id = $request->vehicle;

                    $newproduct->save();

                    # Create it in stocks table..
                    $oldstock = Stock::where("product_id", $request->id[$i])
                        ->where("location_id", $request->location)
                        ->first();

                    $newstock = new Stock();

                    $newstock->product_id = $newproduct->id;
                    $newstock->location_id = $request->vehicle;
                    $newstock->unit_id = $oldstock->unit_id;
                    $newstock->min_cont = $oldstock->min_cont;
                    $newstock->min_qty = $oldstock->min_qty;
                    $newstock->qty = $request->qty[$i] * $request->cont[$i];
                    $newstock->exp = $oldstock->exp;
                    $newstock->exp_not = $oldstock->exp_not;

                    $newstock->save();

                    # Create it in unit_assingneds table..
                    $oldunits = UnitAssigned::where("product_id", $request->id[$i])
                        ->where("location_id", $request->location)
                        ->get();

                    foreach ($oldunits as $oldunit) {

                        $newunit = new UnitAssigned();

                        $newunit->product_id = $newproduct->id;
                        $newunit->unit_id = $oldunit->unit_id;
                        $newunit->unit_cont = $oldunit->unit_cont;
                        $newunit->selling = $oldunit->selling;
                        $newunit->location_id = $request->vehicle;

                        $newunit->save();
                    }

                    # Save stock movement for that specific product in the vehicle.
                    $movement = new StockMovement();

                    $movement->date = $request->date;
                    $movement->user_id = auth()->user()->id;
                    $movement->product_id = $request->id[$i];
                    $movement->reason = "Vehicle Loaded";
                    $movement->status = "Out";
                    $movement->qty = $request->qty[$i] * $request->cont[$i];
                    $movement->before = 0;
                    $movement->after = $request->qty[$i] * $request->cont[$i];
                    $movement->location_id = $request->vehicle;

                    $movement->save();
                }

                # Stock movement.
                $stockOut = Stock::where("location_id", $request->location)
                    ->where("product_id", $request->id[$i])
                    ->first();

                # Save stock movement for that specific product kule ilipotoka.
                $movement = new StockMovement();

                $movement->date = $request->date;
                $movement->user_id = auth()->user()->id;
                $movement->product_id = $request->id[$i];
                $movement->reason = "Vehicle Loaded";
                $movement->status = "Out";
                $movement->qty = $request->qty[$i] * $request->cont[$i];
                $movement->before = $stockOut->qty;
                $movement->after =  $stockOut->qty - ($request->qty[$i] * $request->cont[$i]);
                $movement->location_id = $request->location;

                $movement->save();

                # Decrement that paticular product qty in stocks table
                $stockOut->qty -= $request->qty[$i] * $request->cont[$i];
                $stockOut->update();
            }

            #commit
            DB::commit();

            return back()->with("success", "Vehicle successfully loaded!!");
        } catch (Exception $e) {
            # rollback
            DB::rollback();

            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    public function unloadVehicleStore(Request $request)
    {
        try {
            # Find the selected vehicle with the selected driver & salesman whose status is loaded.
            $loaded_vehicle = LoadVehicle::where("vehicle", $request->vehicle)
                ->where("salesman", $request->salesman)
                ->where("driver", $request->driver)
                ->first();

            # If nothing is sold insert nothing sales,transaction and account table
            if ($request->sold != 0) {
                # Post sales(cash or credit (salesmen))
                $sale = new Sale();

                $sale->user = auth()->user()->name;
                $sale->date = $request->date;
                $sale->location = $loaded_vehicle->source;
                $sale->total = $request->discount + $request->sold;
                $sale->discount = $request->discount;
                $sale->net = $request->sold;
                $sale->paid = $request->paid;
                $sale->due = $request->due;
                $sale->account = $request->account;
                $sale->salesman = $request->salesman;

                if ($request->due == 0) {
                    $sale->status = "cash";
                } else {
                    $sale->duedate = $request->duedate;
                    $sale->notification = $request->notification;
                    $sale->status = "credit";
                }

                $sale->save();

                # If account is selected proceed
                if ($request->account) {
                    # Record the cash movement of the selected account
                    $account  = Account::where("name", $request->account)
                        ->where("selling_location", $loaded_vehicle->source)
                        ->first();

                    # Record cash movement in the selected account
                    $transaction = new Transaction();

                    $transaction->date = $request->date;
                    $transaction->user = auth()->user()->name;
                    $transaction->reason = "Sale";
                    $transaction->status = "In";
                    $transaction->amount = $request->paid;
                    $transaction->before = $account->balance;
                    $transaction->after = $account->balance + $request->paid;
                    $transaction->account = $request->account;
                    $transaction->selling_location = $loaded_vehicle->source;

                    $transaction->save();

                    $account->balance +=  $request->paid;
                    $account->update();
                }
            }

            # Loop through the unloaded items
            for ($u = 0; $u < count($request->product); $u++) {

                # From the loaded_item get each unloaded item
                $loaded_item = LoadedItems::where("load_vehicle_id", $loaded_vehicle->id)
                    ->where("product_id", $request->id[$u])
                    ->first();

                # If nothing is sold insert nothing in sold_items table
                if ($request->sold != 0) {
                    # Get the base unit of each unloaded product
                    $base_unit = UnitAssigned::where("product", $request->product[$u])
                        ->where("location", $request->vehicle)
                        ->orderBy("unitcont", "asc")
                        ->first();

                    # If unloaded item qty is not equal to the loaded item qty don't insert
                    if ($request->qty[$u] != $loaded_item->qty) {
                        # Inserting sold items in sold_items table
                        $sold_items = new SoldItem();
                        $sold_items->sale_id = $sale->id;
                        $sold_items->product_id = $request->id[$u];
                        $sold_items->product = $request->product[$u];
                        $sold_items->unit = $base_unit->unit;
                        $sold_items->cont = $base_unit->unitcont;
                        $sold_items->qty = $loaded_item->qty - $request->qty[$u] * $request->cont[$u];
                        $sold_items->price = $base_unit->selling;
                        $sold_items->amount = $loaded_item->amount - ($request->qty[$u] * $request->cont[$u] * $base_unit->selling);
                        $sold_items->save();
                    }
                }

                # Get unloaded vehicle stock
                $vehicle_stock = Stock::where("product", $request->product[$u])
                    ->where("location", $request->vehicle)
                    ->first();

                # Record vehicle stock movement
                $movement = new StockMovement();

                $movement->date = $request->date;
                $movement->user = auth()->user()->name;
                $movement->product = $request->product[$u];
                $movement->reason = "Unloaded";
                $movement->status = "Out";
                $movement->qty = $request->qty[$u] * $request->cont[$u];
                $movement->before = $vehicle_stock->qty;
                $movement->after = 0;
                $movement->location = $request->vehicle;

                $movement->save();

                # Update vehicle stock qty
                $vehicle_stock->qty = 0;
                $vehicle_stock->update();

                # Check if the unloaded product exists in the selected location
                if (Stock::where("product_id", $request->id[$u])
                    ->where("location", $request->location)
                    ->exists()
                ) {

                    # If yes get it
                    $location_stock = Stock::where("product_id", $request->id[$u])
                        ->where("location", $request->location)
                        ->first();

                    # Record location stock movement
                    $movement = new StockMovement();

                    $movement->date = $request->date;
                    $movement->user = auth()->user()->name;
                    $movement->product = $request->product[$u];
                    $movement->reason = "Vehicle unloaded";
                    $movement->status = "In";
                    $movement->qty = $request->qty[$u] * $request->cont[$u];
                    $movement->before = $location_stock->qty;
                    $movement->after = $location_stock->qty + ($request->qty[$u] * $request->cont[$u]);
                    $movement->location = $request->vehicle;

                    $movement->save();

                    # Update vehicle stock qty
                    $location_stock->qty += $request->qty[$u] * $request->cont[$u];
                    $location_stock->update();
                } else {

                    # If it doesn't exist then create it in products table.
                    $oldproduct = Product::where("id", $request->id[$u])
                        ->where("location", $request->vehicle)
                        ->first();

                    $newproduct = new Product();

                    $newproduct->barcode = $oldproduct->barcode;
                    $newproduct->product = $request->product[$u];
                    $newproduct->category = $oldproduct->category;
                    $newproduct->buying = $oldproduct->buying;
                    $newproduct->supplier = $oldproduct->supplier;
                    $newproduct->location = $request->vehicle;

                    $newproduct->save();

                    # Create it in stocks table
                    $oldstock = Stock::where("product_id", $request->id[$u])
                        ->where("location", $request->vehicle)
                        ->first();

                    $newstock = new Stock();

                    $newstock->product_id = $newproduct->id;
                    $newstock->product = $request->product[$u];
                    $newstock->location = $request->vehicle;
                    $newstock->minunit = $oldstock->minunit;
                    $newstock->mincont = $oldstock->mincont;
                    $newstock->minqty = $oldstock->minqty;
                    $newstock->qty = $request->qty[$u] * $request->cont[$u];
                    $newstock->exp = $oldstock->exp;
                    $newstock->expnot = $oldstock->expnot;

                    $newstock->save();

                    # Create it in unit_assingneds table..
                    $oldunits = UnitAssigned::where("product_id", $request->id[$u])
                        ->where("location", $request->vehicle)
                        ->get();

                    foreach ($oldunits as $oldunit) {

                        $newunit = new UnitAssigned();

                        $newunit->product_id = $newproduct->id;
                        $newunit->product = $request->product[$u];
                        $newunit->location = $request->vehicle;
                        $newunit->unit = $oldunit->unit;
                        $newunit->unitcont = $oldunit->unitcont;
                        $newunit->selling = $oldunit->selling;

                        $newunit->save();
                    }

                    # Record seletcted location stock movement
                    $movement = new StockMovement();

                    $movement->date = $request->date;
                    $movement->user = auth()->user()->name;
                    $movement->product = $request->product;
                    $movement->reason = "Vehicle unloaded";
                    $movement->status = "In";
                    $movement->qty = $request->qty[$u] * $request->cont[$u];
                    $movement->before = 0;
                    $movement->after = $request->qty[$u] * $request->cont[$u];
                    $movement->location = $request->vehicle;

                    $movement->save();
                }

                # Delete loaded each unloaded items
                $loaded_item->delete();
            }

            # Delete the loaded vehicle
            $loaded_vehicle->delete();

            return redirect()->back()->with("success", "Vehicle unloaded successfully.");
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $vehicle = Vehicle::find($id);

            $location = Location::where("name", $vehicle->name)->first();
            $location->name = $request->name;
            $location->update();

            //update location name in products table.
            $products = Product::where("location", $vehicle->name)->get();

            if (count($products) > 0) {
                foreach ($products as $product) {
                    $product->location = $request->name;
                    $product->update();
                }
            }

            //update location name in stocks table.
            $stocks = Stock::where("location", $vehicle->name)->get();

            if (count($stocks) > 0) {
                foreach ($stocks as $stock) {
                    $stock->location = $request->name;
                    $stock->update();
                }
            }

            //update location name in unitassigned table.
            $units = UnitAssigned::where("location", $vehicle->name)->get();

            if (count($units) > 0) {
                foreach ($units as $unit) {
                    $unit->location = $request->name;
                    $unit->update();
                }
            }

            $vehicle->name = $request->name;
            $vehicle->update();

            return back()->with("success", "Successfully updated!!");
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            Vehicle::find($id)->delete();
            return back()->with("success", "Successfully deleted!!");
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    public function bulkDelete(Request $request)
    {
        try {
            $ids = $request->ids;

            $results = "";

            foreach ($ids as $id) {
                $results = Vehicle::find($id)->delete();
            }
            return response()->json($results);
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    public function totalValueLoaded(Request $request)
    {
        try {
            $vehicle = $request->get("vehicle");

            $total = LoadVehicle::select("total", "salesman", "driver")
                ->where("vehicle", $vehicle)
                ->first();

            return response()->json($total);
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    public function loadedVehicle(Request $request)
    {
        //try {
        $loaded_vehicles = collect();
        $loaded_items = collect();

        return view('loaded-vehicle', compact(
            'loaded_vehicles',
            'loaded_items'
        ));
        // } catch (Exception $e) {
        //     // Return a custom error response
        //     return response()->json(['error' => 'Something went wrong'], 500);
        // }
    }

    public function deleteLoadedVehicle($id)
    {
        try {
            $vehicle = LoadVehicle::find($id);
            $items = LoadedItems::where("load_vehicle_id", $id)->get();

            foreach ($items as $item) {
                $answer = $item->cont * $item->qty;

                # Decrement vehicle stock qty
                Stock::where("location", $vehicle->vehicle)
                    ->where("product", $item->product)
                    ->decrement("qty", $answer);

                # Increment source stock qty
                Stock::where("location", $vehicle->source)
                    ->where("product", $item->product)
                    ->increment("qty", $answer);

                # Delete each loaded item
                $item->delete();
            }

            # Delete loaded vehicle
            $vehicle->delete();

            return redirect()->route('loaded.vehicle')->with("success", "Deleted successfully!!");
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    public function loadedItemsBulkDelete(Request $request)
    {
        try {
            $ids = $request->ids;

            $results = "";

            foreach ($ids as $id) {
                $item = LoadedItems::find($id);
                $vehicle = LoadVehicle::find($item->load_vehicle_id);

                $vehicle->total -= $item->cont * $item->qty * $item->price;
                $vehicle->update();

                # Decrement vehicle stock qty
                Stock::where("location", $vehicle->vehicle)
                    ->where("product", $item->product)
                    ->decrement("qty", $item->cont * $item->qty);

                # Increment source stock qty
                Stock::where("location", $vehicle->source)
                    ->where("product", $item->product)
                    ->increment("qty", $item->cont * $item->qty);

                # Delete each loaded item
                $item->delete();

                if ($vehicle->total == 0) {
                    $vehicle->delete();
                }
            }

            return response()->json($results);
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }
}
