<?php

namespace App\Http\Controllers;

use App\Models\Account;
use App\Models\Event;
use App\Models\Transaction;
use App\Models\Venue;
use App\Models\VenueBooking;
use Illuminate\Http\Request;

class VenueController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $venues = Venue::all();
        return view("venue", compact("venues"));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $venue = new Venue();

        $venue->name = $request->name;
        $venue->pax = $request->pax;
        $venue->price = $request->price;
        $venue->features = $request->description;
        $venue->status = "";
        $venue->block = "";
        $venue->reason = "";
        $venue->date = "";


        $venue->save();

        return back()->with("success", "Venue added!!");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $venue = Venue::find($id);
        $venue->name = ucwords($request->name);
        $venue->pax = $request->pax;
        $venue->price = $request->price;
        $venue->features = $request->description;
        $venue->update();

        return back()->with("success", "Successfully updated!!");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Venue::find($id)->delete();

        return back()->with("success", "Deleted successfully!!");
    }

    public function bulkDelete(Request $request)
    {
        $ids = $request->ids;

        $results = "";

        foreach ($ids as $id) {
            $results = Venue::find($id)->delete();
        }
        return response()->json($results);
    }
    public function block(Request $request,  $id)
    {

        $venue = Venue::find($id);

        if ($request->reason == "") {
            $venue->block = null;
            $venue->reason = null;
        } else {
            $venue->block = "Blocked";
            $venue->reason = $request->reason;
        }
        $venue->update();

        if ($request->reason == "") {
            return back()->with("success", "Venue unblocked!!");
        } else {
            return back()->with("success", "Venue blocked!!");
        }
    }

    public function venueCheckout(Request $request){
     # Free the venue.
     $venue = Venue::where("name", $request->venue)->first();
     $venue->date = "";
     $venue->status = "";
     $venue->update();

     # From the booking table delete the venue.
      VenueBooking::where("venue", $request->venue)->delete();

     # Check if there's any amount paid.
     if($request->pdue){
        # Get the selected account.
        $account = Account::where("name", $request->account)->first();

        # Record the cash movement.
        $transaction = new Transaction();

        $transaction->date = $request->date;
        $transaction->user = auth()->user()->name;
        $transaction->reason = "venue payment";
        $transaction->status = "In";
        $transaction->amount = $request->pdue;
        $transaction->before = $account->balance;
        $transaction->after = $account->balance + $request->pdue;
        $transaction->account = $request->account;
        $transaction->selling_location = "Default shop";

        $transaction->save();

        # Update the account balance.
        $account->balance +=  $request->pdue;
        $account->update();

        return back()->with("success", "Success");


     }
    }
}
