<?php

namespace App\Imports;

use App\Models\Location;
use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\Unit;
use App\Models\UnitAssigned;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Support\Facades\DB;

class MenuImport implements ToCollection, WithHeadings
{
    /**
     * @param Collection $collection
     */
    public function collection(Collection $rows)
    {
        try {
            DB::beginTransaction();

            $index = 0;
            foreach ($rows as $row) {
                # Skip the first row.
                if ($index == 0) {
                    $index++;
                    continue;
                }

                $product = $row[0];
                $category = $row[1] ?? 1; // Default to category ID 1 (menu) if not provided
                $unit = $row[2];
                $selling = $row[4];
                $location = $row[5];

                // Check if the product category exists, if not, create it.
                $categoryData = ProductCategory::where("name", $category)->first();
                if (!$categoryData) {
                    $newCategory = new ProductCategory();
                    $newCategory->name = $category;
                    $newCategory->save();

                    $categoryData = $newCategory;
                }

                // Check if the location exists, if not, create it.
                $locationData = Location::where("name", ucwords($location))->first();
                if (!$locationData) {
                    // You might need to add this code to create the location if not found
                    $newLocation = new Location();
                    $newLocation->name = ucwords($location);
                    $newLocation->save();
                    $locationData = $newLocation;
                }

                // Check if the unit exists, if not, create it.
                $unitData = Unit::where("name", ucwords($unit))->first();
                if (!$unitData) {
                    $newUnit = new Unit();
                    $newUnit->name = ucwords($unit);
                    $newUnit->save();
                    $unitData = $newUnit;
                }

                // Check if the product exists, if not, create it.
                $duplicateProduct = Product::where("product", $product)->exists();
                if (!$duplicateProduct) {
                    $newProduct = new Product();
                    $newProduct->product = ucwords($product);
                    $newProduct->category_id = $categoryData->id;
                    $newProduct->buying = 0;
                    $newProduct->location_id = $locationData->id;
                    $newProduct->save();
                } else {
                    $newProduct = Product::where("product", $product)->first();
                }

                $newUnitAssigned = new UnitAssigned();
                $newUnitAssigned->product_id = $newProduct->id; // Use $newProduct here
                $newUnitAssigned->unit_id = $unitData->id;
                $newUnitAssigned->unit_cont = 1;
                $newUnitAssigned->selling = $selling;
                $newUnitAssigned->location_id = $locationData->id;
                $newUnitAssigned->save();
            }

            DB::commit(); // Commit the transaction if everything is successful

            return redirect()->back()->with('success', 'Data imported successfully');
        } catch (\Exception $e) {
            DB::rollBack(); // Rollback changes if an exception occurs
            // You can log the error or handle it in a way that makes sense for your application
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    public function headings(): array
    {

        return [
            "PRODUCT",
            "CATEGORY",
            "UNIT",
            "CONTENT",
            "PRICE",
            "LOCATION",
        ];
    }
}
