<?php

namespace App\Imports;

use App\Models\Product;
use App\Models\SoldItem;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;

class SoldItemsImport implements ToCollection
{
    /**
     * @param Collection $collection
     */
    public function collection(Collection $rows)
    {
        foreach ($rows as $row) {

            $product = Product::where("name", $row[1])
            ->where("location", "Default shop")
            ->first();

            $item = new SoldItem();

            $item->sale_id = $row[0];
            $item->product = $row[1];
            $item->product_id = $product->id ;
            $item->unit = $row[3];
            $item->cont = $row[4];
            $item->price = $row[5];
            $item->qty = $row[6];
            $item->amount = $row[7];

            $item->save();
        }
    }
}
