<?php

namespace App\Imports;

use App\Models\Supplier;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;

class SupplierImport implements ToCollection
{
    /**
     * @param Collection $collection
     */
    public function collection(Collection $rows)
    {

        $index = 0;
        # Loop through each row in the uploaded execl.
        foreach ($rows as $row) {
            # Skip the first row.
            if ($index == 0) {
                $index++;
                continue;
            }
            # Check if the supplier exists.
            $supplier_check = Supplier::where("name", ucwords($row[0]))->exists();
            # If the supplier doesn't exist create new entry.
            if ($supplier_check == false) {
                $supplier = new Supplier();
                $supplier->name =  ucwords($row[0]);
                $supplier->address =  $row[1];
                $supplier->phone =  $row[2];
                $supplier->tin = $row[3];
                $supplier->vrn =  $row[4];
                $supplier->location_id =  2;
                $supplier->save();
            }
        }
    }
}
