<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Bill extends Model
{
    use HasFactory;

    protected $fillable = [
        'date',
        'location',
        'waiter',
        'table',
        'total',
    ];

    public function items()
    {
        return $this->hasMany(BillItems::class, 'bill_id', 'id');
    }
}
