<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BillItems extends Model
{
    use HasFactory;

    protected $fillable = [
        'bill_id',
        'product',
        'unit',
        'qty',
        'price',
        'amount'
    ];

    public function bill()
    {
        return $this->belongsTo(PendingBill::class, 'bill_id', 'id');
    }
}
