<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Booking extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'selling_id',
        'in_date',
        'days',
        'customer',
        'phone',
        'comment',
        'room_id',
        'total',
        'paid',
        'due',
        'account_id',
        'status',
        'total_bill',
    ];


    # Room relationship
    public function room()
    {
        return $this->belongsTo(Room::class);
    }

    # User relationship
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    # Selling relationship
    public function selling()
    {
        return $this->belongsTo(Selling::class);
    }

    # Account relationship
    public function account()
    {
        return $this->belongsTo(Account::class);
    }
}
