<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'address',
        'phone',
        'limit',
        'vrn',
        'tin',
        'advance',
        'description',
        'opening_balance',
        "selling_id"
    ];

    public function saleReturn()
    {
        return $this->hasMany(Account::class);
    }

    public function debts()
    {
        return $this->hasMany(Debts::class);
    }

    public function sale()
    {
        return $this->hasMany(Sale::class);
    }

    public function selling()
    {
        return $this->belongsTo(Selling::class);
    }

    public function profoma()
    {
        return $this->hasMany(ProfomaInvoice::class);
    }
}
