<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CustomerOrder extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $guarded = [
        'date',
        'customer_id',
        'user_id',
        'total_buying',
        'total_selling',
        'total_profit',
        'paid',
        'due',
        'status',
        'account_id',
    ];

    protected $dates = [
        'deleted_at',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }

    public function account()
    {
        return $this->belongsTo(Account::class, 'account_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function orderItems()
    {
        return $this->hasMany(CustomerOrderItem::class, 'customer_order_id');
    }
}
