<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Damage extends Model
{
    use HasFactory;

    protected $fillable = [
        'date',
        'user_id',
        'product_id',
        'reason',
        'unit_id',
        'price',
        'cont',
        'location_id',
        'qty',
    ];

    // In Damage.php model
    public function stock()
    {
        return $this->belongsTo(Stock::class, 'product_id', 'product_id')
            ->whereColumn('location_id', 'damages.location_id');
    }

    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function unit()
    {
        return $this->belongsTo(Unit::class);
    }
}
