<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ExpenseCategory extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $fillable = ['name', 'expense_type'];
    protected $dates = ['deleted_at'];

    public function expense()
    {
        return $this->hasMany(PostExpense::class);
    }
}
