<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ingredient extends Model
{
    use HasFactory;
    protected $fillable = [
        'barcode',
        'image',
        'name',
        'buying',
        'unit_id',
        'min_qty',
        'qty',
        'exp',
        'exp_not',
        'location_id',
    ];


    public function unit()
    {
        return $this->belongsTo(Unit::class);
    }

    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    public function menuItems()
    {
        return $this->hasMany(MenuItems::class);
    }
}
