<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LoadVehicle extends Model
{
    use HasFactory;

    protected $fillable = [
        'date',
        'user_id',
        'selling_id',
        'drivers_id',
        'salesmen_id',
        'total',
        'status',
    ];

    # Loaded items relation
    public function loadedItems()
    {
        return $this->hasMany(loadedItems::class);
    }

    # User relation
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    # Selling relation
    public function selling()
    {
        return $this->belongsTo(Selling::class);
    }

    # Driver relation
    public function driver()
    {
        return $this->belongsTo(Driver::class);
    }

    # salesmen relation
    public function salesmen()
    {
        return $this->belongsTo(Salesmen::class);
    }
}
