<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Location extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $fillable = [
        'name',
        'owner',
        'phone',
        'type',
        'status'
    ];

    protected $dates = ['deleted_at'];

    public function damage()
    {
        return $this->hasMany(Damage::class);
    }

    public function purchase()
    {
        return $this->hasMany(Purchase::class);
    }

    public function profoma()
    {
        return $this->hasMany(ProfomaInvoice::class);
    }

    public function customer()
    {
        return $this->hasMany(Customer::class);
    }

    public function unitAssigned()
    {
        return $this->hasMany(unitAssigned::class);
    }

    public function expense()
    {
        return $this->hasMany(PostExpense::class);
    }

    public function product()
    {
        return $this->hasMany(Product::class);
    }

    public function supplier()
    {
        return $this->hasMany(Supplier::class);
    }

    public function supplierDebts()
    {
        return $this->hasMany(SupplierDebts::class);
    }

    public function debt()
    {
        return $this->hasMany(Debts::class);
    }

    public function transaction()
    {
        return $this->hasMany(Transaction::class);
    }

    public function sales()
    {
        return $this->hasMany(Sale::class);
    }

    public function movement()
    {
        return $this->hasMany(StockMovement::class);
    }

    public function transfer()
    {
        return $this->hasMany(StockTransfer::class);
    }

    # Selling relations.
    public function selling()
    {
        return $this->hasMany(Selling::class);
    }

    # Storage relations.
    public function storage()
    {
        return $this->hasMany(Storage::class);
    }

    # Main relations.
    public function main()
    {
        return $this->hasMany(Main::class);
    }

    public function stock()
    {
        return $this->hasMany(Stock::class);
    }
}
