<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PostExpense extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'date',
        'selling_id',
        'category_id',
        'description',
        'sum',
        'total',
        'account_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function category()
    {
        return $this->belongsTo(ExpenseCategory::class);
    }

    public function selling()
    {
        return $this->belongsTo(Selling::class);
    }
}
