<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

//use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{
    use HasFactory, SoftDeletes;
    //use SoftDeletes;

    protected $fillable = [
        "image",
        "barcode",
        "product",
        "description",
        "category_id",
        "buying",
        "supplier_id",
        "location_id",
    ];

    # OPening and closing relation
    public function openingClosing()
    {
        return $this->hasMany(OpeningClosingStock::class);
    }

    # Loaded items relation
    public function loadedItems()
    {
        return $this->hasMany(loadedItems::class);
    }

    public function menuItems()
    {
        return $this->hasMany(MenuItems::class);
    }

    public function serviceProduct()
    {
        return $this->hasMany(ServiceProduct::class);
    }

    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    public function transfer()
    {
        return $this->hasMany(StockTransfer::class);
    }

    public function damage()
    {
        return $this->hasMany(Damage::class);
    }

    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }

    public function category()
    {
        return $this->belongsTo(ProductCategory::class);
    }

    public function movement()
    {
        return $this->hasMany(StockMovement::class);
    }

    public function sales()
    {
        return $this->hasMany(Sale::class);
    }

    public function stock()
    {
        return $this->hasMany(Stock::class);
    }

    public function unit()
    {
        return $this->hasMany(UnitAssigned::class);
    }

    public function soldItems()
    {
        return $this->hasMany(SoldItem::class);
    }

    public function purchasedItems()
    {
        return $this->hasMany(PurchasedItem::class);
    }

     public function cartItems()
    {
        return $this->hasMany(CartItems::class);
    }

     // Get only batch stock (optional)
    public function batchStock()
    {
        return $this->hasMany(Stock::class, 'product_id')
                    ->whereNotNull('batch_no');
    }

    // Get non-batch stock
    public function totalStock()
    {
        return $this->hasMany(Stock::class, 'product_id')
                    ->whereNull('batch_no');
    }
}
