<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseOrder extends Model
{
    use HasFactory;

    use HasFactory;

    protected $fillable = ['date', 'user_id', 'supplier_id', 'total', 'selling_id'];

    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }

    public function selling()
    {
        return $this->belongsTo(Selling::class);
    }

    public function user()
    {
        return $this->belongsTo(user::class);
    }

    public function purchaseOrderItems()
    {
        return $this->hasMany(PurchaseOrderItem::class);
    }

}
