<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RequisitionItem extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['requisition_id', 'product_name', 'qty', 'unit_id', 'note'];

    public function requisition()
    {
        return $this->belongsTo(Requisition::class);
    }

    public function unit()
    {
        return $this->belongsTo(Unit::class);
    }
}
