<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Selling extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'location_id',
        'main_id',
    ];

    public function requisition()
    {
        return $this->hasMany(Requisition::class);
    }

      public function asset()
    {
        return $this->hasMany(Asset::class);
    }

    public function service()
    {
        return $this->hasMany(Service::class);
    }

    public function booking()
    {
        return $this->hasMany(Booking::class);
    }

    public function vehicle()
    {
        return $this->hasMany(Vehicle::class);
    }

    public function room()
    {
        return $this->hasMany(Room::class);
    }

    public function waiter()
    {
        return $this->hasMany(Waiter::class);
    }

    public function table()
    {
        return $this->hasMany(Table::class);
    }

    public function purchaseReturn()
    {
        return $this->hasMany(PurchaseReturn::class);
    }

    public function saleReturn()
    {
        return $this->hasMany(Account::class);
    }

    # User relation.
    public function user()
    {
        return $this->hasMany(User::class);
    }

    # Location relation.
    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    # Production relation.
    public function productionOrder()
    {
        return $this->hasMany(ProductionOrder::class);
    }

    # Storage relations.
    public function storage()
    {
        return $this->hasMany(Storage::class);
    }

    # Business Profile relation.
    public function businessProfile()
    {
        return $this->hasMany(BusinessProfile::class);
    }

    # Account relation.
    public function account()
    {
        return $this->hasMany(Account::class);
    }

    # transaction relation.
    public function transaction()
    {
        return $this->hasMany(Transaction::class);
    }

    # Customer relation.
    public function customer()
    {
        return $this->hasMany(Customer::class);
    }

    # Supplier relation.
    public function supplier()
    {
        return $this->hasMany(Supplier::class);
    }

    # Debts relation.
    public function debts()
    {
        return $this->hasMany(Debts::class);
    }

    # Supplier debts relation.
    public function supplierDebts()
    {
        return $this->hasMany(SupplierDebts::class);
    }

    #  Purchases relation.
    public function purchase()
    {
        return $this->hasMany(Purchase::class);
    }

    #  Purchase order relation.
    public function purchaseOrder()
    {
        return $this->hasMany(PurchaseOrder::class);
    }

    #  Sale relation.
    public function sale()
    {
        return $this->hasMany(Sale::class);
    }

    # Expense relations.
    public function expense()
    {
        return $this->hasMany(PostExpense::class);
    }

    # Loaded vehicle relations.
    public function loadedVehicle()
    {
        return $this->hasMany(LoadVehicle::class);
    }

    #  Profoma invoice relation.
    public function profomaInvoice()
    {
        return $this->hasMany(Profoma::class);
    }
}
