<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SoldItem extends Model
{
    use HasFactory;

    protected $fillable = ["sale_id", "product_id", "unit_id", "cont","price", "qty","amount", "discount", "batch_no"];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function unit()
    {
        return $this->belongsTo(Unit::class);
    }

    public function sale()
    {
        return $this->belongsTo(Sale::class);
    }

}
