<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StockMovement extends Model
{
    use HasFactory;

    protected $table = 'stock_movements';

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'date',
        'user_id',
        'product_id',
        'location_id',
        'reason',
        'status',
        'qty',
        'before',
        'after',
        'batch_no',
        'exp',
    ];

    /**
     * The attributes that should be cast to native types.
     */
    protected $casts = [
        'date' => 'date',
        'exp'  => 'date',
    ];

    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function unit()
    {
        return $this->belongsTo(unit::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

}
