<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StockTransfer extends Model
{
    use HasFactory;

    protected $fillable = [
        'date',
        'location_id',
        'user_id',
        'product_id',
        'batch_no',
        'unit_id',
        'cont',
        'from',
        'to',
        'qty',
        'price',
    ];

    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function unit()
    {
        return $this->belongsTo(unit::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
