<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Supplier extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'address',
        'phone',
        'email',
        'vrn',
        'tin',
        'advance',
        'description',
        'opening_balance',
        'selling_id'
    ];

    public function requisition()
    {
        return $this->belongsTo(Requisition::class);
    }

    public function purchaseReturn()
    {
        return $this->hasMany(PurchaseReturn::class);
    }

    public function selling()
    {
        return $this->belongsTo(Selling::class);
    }

    public function supplierDebts()
    {
        return $this->hasMany(SupplierDebts::class);
    }

    public function product()
    {
        return $this->hasMany(Product::class);
    }

    public function purchase()
    {
        return $this->hasMany(Purchase::class);
    }

    public function purchaseOrder()
    {
        return $this->hasMany(PurchaseOrder::class);
    }
}
