<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Table extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'flag',
        'selling_id',
        'pos_x',
        'pos_y',
    ];

    public function selling()
    {
        return $this->belongsTo(Selling::class);
    }

    public function sale()
    {
        return $this->hasMany(Waiter::class);
    }

    public function reservation()
    {
        return $this->hasMany(TableReservation::class);
    }

    public function cart()
    {
        return $this->hasMany(Cart::class);
    }
}
