<?php

namespace Database\Factories;

use App\Models\TableReservation;
use App\Models\Table;
use Illuminate\Database\Eloquent\Factories\Factory;

class TableReservationFactory extends Factory
{
    protected $model = TableReservation::class;

    public function definition()
    {
        $statuses = ['booked', 'checked_in', 'completed', 'cancelled'];

        return [
            'table_id' => Table::inRandomOrder()->value('id') ?? 1, // fallback if no table exists
            'customer_name' => $this->faker->name(),
            'customer_phone' => $this->faker->optional()->phoneNumber(),
            'guest_count' => $this->faker->numberBetween(1, 8),
            'booking_start' => $this->faker->dateTimeBetween('now', '+1 day'),
            'booking_end' => $this->faker->optional()->dateTimeBetween('+1 hour', '+2 days'),
            'status' => $this->faker->randomElement($statuses),
        ];
    }
}
