<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('post_expenses', function (Blueprint $table) {
            $table->id();
            $table->string('user_id');
            $table->string('date');
            $table->unsignedBigInteger('selling_id');
            $table->string('category_id');
            $table->string('description')->nullable();
            $table->bigInteger('sum');
            $table->bigInteger('total');
            $table->string('account_id');
            $table->integer('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('post_expenses');
    }
};
