<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();

            // Fields likely to be searched
            $table->string('barcode')->nullable();
            $table->string('product');
            $table->string('description')->nullable();

            // Optional metadata
            $table->string('image')->nullable();
            $table->integer('category_id')->nullable();
            $table->unsignedInteger('supplier_id')->nullable();
            $table->unsignedInteger('location_id');

            $table->integer('buying')->default(0);

            $table->softDeletes();
            $table->timestamps();

            // Full-text index for search optimization
            $table->fullText(['product', 'barcode']);

            // ✅ Regular indexes for search and filters
            $table->index('product');       // Index for LIKE 'query%' matching
            $table->index('barcode');       // Index for exact product lookup via barcode
            $table->index('location_id');   // For location-based filtering
            $table->index('category_id');   // For category filtering
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
};
