<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('purchases', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('account_id')->nullable();
            $table->unsignedBigInteger('supplier_id');
            $table->unsignedBigInteger('selling_id');
            $table->unsignedBigInteger('location_id');
            $table->string('date');
            $table->bigInteger('total');
            $table->bigInteger('discount')->nullable();
            $table->bigInteger('net');
            $table->bigInteger('paid');
            $table->bigInteger('due');
            $table->integer('invoice');
            $table->string('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('purchases');
    }
};
