<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('debts', function (Blueprint $table) {
            $table->id();
            $table->date('date');
            $table->unsignedBigInteger('selling_id');
            $table->unsignedBigInteger('sale_id')->nullable();
            $table->unsignedBigInteger('production_order_id')->nullable();
            $table->unsignedBigInteger('customer_id');
            $table->unsignedBigInteger('account_id')->nullable();
            $table->bigInteger('amount')->nullable();
            $table->bigInteger('discount')->nullable();
            $table->bigInteger('paid')->nullable();
            $table->bigInteger('due')->nullable();
            $table->bigInteger('opening_balance')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('debts');
    }
};
