<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('venue_bookings', function (Blueprint $table) {
            $table->id();
            $table->date("date");
            $table->unsignedBigInteger("customer_id");
            $table->unsignedBigInteger("account_id")->nullable();
            $table->unsignedBigInteger("venue_id");
            $table->unsignedBigInteger("event_id");
            $table->integer("phone");
            $table->string("start_time");
            $table->string("end_time");
            $table->string("comment");
            $table->integer("pax");
            $table->integer("total");
            $table->integer("discount");
            $table->integer("net");
            $table->integer("paid");
            $table->integer("due");
            $table->string("status");

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('venue_bookings');
    }
};
