<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ingredients', function (Blueprint $table) {
            $table->id();
            $table->string('barcode')->nullable();
            $table->string('image')->nullable();
            $table->string('name');
            $table->integer('buying');
            $table->unsignedBigInteger('unit_id');
            $table->integer('min_qty');
            $table->integer('qty');
            $table->string('exp')->nullable();
            $table->string('exp_not')->nullable();
            $table->unsignedBigInteger('location_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ingredients');
    }
};
