<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('production_orders', function (Blueprint $table) {
            $table->id();
              $table->string('date');
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('selling_id');
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->unsignedBigInteger('account_id')->nullable();
            $table->bigInteger('total');
            $table->integer('type');
            $table->integer('genre');
            $table->bigInteger('paid')->nullable();
            $table->bigInteger('due');
            $table->integer('stage')->nullable();
            $table->string('expectation');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('production_orders');
    }
};
