<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        $tables = [
            'accounts',
            'transactions',
            'suppliers',
            'customers',
            'post_expenses',
            'users',
            'services',
            'profomas',
            'purchase_orders',
            'debts',
            'supplier_debts',
            'purchases',
            'sales',
            'tables',
            'waiters',
            'production_orders',
        ];

        foreach ($tables as $tableName) {
            Schema::table($tableName, function (Blueprint $table) use ($tableName) {
                if (Schema::hasColumn($tableName, 'location_id')) {
                    $table->dropColumn('location_id');
                }
            });
        }
    }

    public function down(): void
    {
        $tables = [
            'accounts',
            'transactions',
            'suppliers',
            'customers',
            'post_expenses',
            'users',
            'services',
            'profomas',
            'purchase_orders',
            'debts',
            'supplier_debts',
            'purchases',
            'sales',
            'tables',
            'waiters',
            'production_orders',
        ];

        foreach ($tables as $tableName) {
            Schema::table($tableName, function (Blueprint $table) use ($tableName) {
                if (!Schema::hasColumn($tableName, 'location_id')) {
                    $table->unsignedBigInteger('location_id')->nullable()->after('id');
                }
            });
        }
    }
};
