<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('carts', function (Blueprint $table) {
            $table->id();
            $table->string('table_id'); // e.g. "T1", "T8", etc.
            $table->foreignId('waiter_id')->nullable()->constrained('waiters')->onDelete('set null');
            $table->enum('status', ['open', 'submitted', 'paid'])->default('open');
            $table->boolean('flag')->default(0); // changed from integer
            $table->timestamp('last_activity_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('carts');
    }
};
