<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Location;
use App\Models\Main;
use App\Models\Selling;
use App\Models\BusinessProfile;

class LocationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Shared location data
        $locationData = [
            'name' => 'Head Office',
            'owner' => 'Admin',
            'phone' => '0717000000',
            'status' => 'static',
        ];

        // Create main location
        $mainLocation = Location::create(array_merge($locationData, ['type' => 'main']));

        // Create selling location
        $sellingLocation = Location::create(array_merge($locationData, ['type' => 'selling']));

        // Create main and selling references
        $main = Main::create([
            'location_id' => $mainLocation->id,
        ]);

        $selling = Selling::create([
            'location_id' => $sellingLocation->id,
            'main_id' => $main->id,
        ]);

        // Create business profile
        BusinessProfile::create([
            'selling_id' => $selling->id,
            'exp_date' => null,
            'device' => null,
            'address' => 'Unknown',
            'phone' => '0717000000',
            'email' => null,
            'website' => null,
            'tin' => null,
            'vrn' => null,
            'slogan' => null,
            'logo' => null,
            'vat' => 'Exclusive',
            'receipt' => 'No',
        ]);
    }
}
