<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

use function Ramsey\Uuid\v1;

class RoleSedeer extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Role::create(['name' => 'Admin']);
        Role::create(['name' => 'Manager']);
        Role::create(['name' => 'Accountant']);
        Role::create(['name' => 'Cashier']);
        Role::create(['name' => 'Counter']);
        Role::create(['name' => 'Waiter']);
        Role::create(['name' => 'Supervisor']);
        Role::create(['name' => 'Seller']);

        $permissions = Permission::all(); # Get all permissions.
        $role = Role::where("name", "Admin")->first(); # Get admin role.
        if($role){ # validate role.
            foreach ($permissions as $permission) { # Loop through each permisson.
                $role->givePermissionTo($permission->name); # Assign each permission to role.
            }
        }
    }
}
