@extends('layouts.master')

@section('content')
    <div class="container py-4">

        {{-- ===== PAGE HEADING ===== --}}
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h5 class="mb-0">Accounting Overview as of {{ $dateLabel }}</h5>
        </div>

        {{-- ===== FILTER FORM ===== --}}
        <form method="GET" action="{{ route('accounting.overview') }}" class="row g-3 mb-4">
            <div class="col-md-3">
                <label for="type" class="form-label">Duration Type</label>
                <select id="type" name="type" class="form-control">
                    <option value="today" {{ $type == 'today' ? 'selected' : '' }}>Today ({{ now()->format('Y-m-d') }})
                    </option>
                    <option value="this_week" {{ $type == 'this_week' ? 'selected' : '' }}>This Week</option>
                    <option value="this_month" {{ $type == 'this_month' ? 'selected' : '' }}>This Month</option>
                    <option value="custom" {{ $type == 'custom' ? 'selected' : '' }}>Custom Duration</option>
                </select>
            </div>

            <div class="col-md-3" id="startField" style="{{ $type == 'custom' ? '' : 'display:none;' }}">
                <label for="start" class="form-label">Start Date</label>
                <input type="date" id="start" name="start" class="form-control" value="{{ $start }}">
            </div>

            <div class="col-md-3" id="endField" style="{{ $type == 'custom' ? '' : 'display:none;' }}">
                <label for="end" class="form-label">End Date</label>
                <input type="date" id="end" name="end" class="form-control" value="{{ $end }}">
            </div>

            <div class="col-md-3 align-self-end">
                <button type="submit" class="btn btn-primary w-100">Filter</button>
            </div>
        </form>

        <hr class="my-5">

        {{-- ===== TRIAL BALANCE ===== --}}
        <div class="card shadow-sm mb-5">
            <div class="card-body">
                <h5>Trial Balance</h5>
                <p class="text-muted small mb-4">
                    <strong>Overview:</strong> The <em>Trial Balance</em> lists all ledger accounts with their respective
                    debit and credit balances for the selected period.
                    Its purpose is to ensure that total debits equal total credits before preparing financial statements.
                </p>
                <ul class="text-muted small">
                    <li><strong>Debit accounts</strong> include assets and expenses.</li>
                    <li><strong>Credit accounts</strong> include liabilities, income, and equity.</li>
                    <li>If totals do not balance, it signals possible posting or data entry errors.</li>
                </ul>

                <div class="table-responsive mt-4">
                    <table class="table table-bordered table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Account</th>
                                <th>Debit</th>
                                <th>Credit</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($trialBalance as $item)
                                <tr>
                                    <td class="text-start">{{ $item['account'] }}</td>
                                    <td>{{ number_format($item['debit'], 2) }}</td>
                                    <td>{{ number_format($item['credit'], 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="table-light fw-bold">
                            <tr>
                                <th>Total</th>
                                <th>{{ number_format($totalDebit, 2) }}</th>
                                <th>{{ number_format($totalCredit, 2) }}</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>

        <hr class="my-5">

        {{-- ===== PROFIT & LOSS ===== --}}
        <div class="card shadow-sm mb-5">
            <div class="card-body">
                <h5>Profit & Loss Statement</h5>
                <p class="text-muted small mb-4">
                    <strong>Overview:</strong> The <em>Profit & Loss Statement</em> (also called Income Statement)
                    summarizes the company's financial performance over the selected period.
                    It details <strong>revenues</strong> (sales and other income), <strong>cost of goods sold
                        (COGS)</strong>, and <strong>expenses</strong> to calculate the <strong>net profit or loss</strong>.
                    This report helps assess how efficiently the business generates profit, manage costs, and make informed
                    strategic decisions.
                </p>
                <ul class="text-muted small">
                    <li><strong>Revenue:</strong> Total sales generated from products or services during the period.</li>
                    <li><strong>Cost of Goods Sold (COGS):</strong> Direct costs of producing goods or services sold.</li>
                    <li><strong>Expenses:</strong> Operating expenses, salaries, rent, utilities, and other overhead costs.
                    </li>
                    <li><strong>Net Profit / Loss:</strong> Revenue minus COGS and expenses. A positive value indicates
                        profit, while a negative value indicates loss.</li>
                    <li>This statement is crucial for stakeholders to evaluate profitability, plan budgets, and make
                        investment decisions.</li>
                </ul>

                <ul class="list-group mb-3">
                    <li class="list-group-item d-flex justify-content-between">
                        <span>Total Sales</span>
                        <strong>{{ number_format($totalSales, 2) }}</strong>
                    </li>
                    <li class="list-group-item d-flex justify-content-between">
                        <span>Total Purchases</span>
                        <strong>{{ number_format($totalPurchases, 2) }}</strong>
                    </li>
                    <li class="list-group-item d-flex justify-content-between">
                        <span>Expenses</span>
                        <strong>{{ number_format($totalExpenses, 2) }}</strong>
                    </li>
                    <li class="list-group-item d-flex justify-content-between bg-light">
                        <span>Net Profit / Loss</span>
                        <strong>{{ number_format($netProfit, 2) }}</strong>
                    </li>
                </ul>
            </div>
        </div>

        <hr class="my-5">

        {{-- ===== BALANCE SHEET ===== --}}
        <div class="card shadow-sm">
            <div class="card-body">
                <h5>Balance Sheet</h5>
                <p class="text-muted small mb-4">
                    <strong>Overview:</strong> The <em>Balance Sheet</em> provides a snapshot of the company’s financial
                    position at a specific point in time.
                    It shows what the business <strong>owns (Assets)</strong>, what it <strong>owes (Liabilities)</strong>,
                    and the <strong>owner’s interest (Equity)</strong>.
                </p>

                <div class="row">
                    {{-- ===== ASSETS ===== --}}
                    <div class="col-md-6">
                        <h5>Assets</h5>
                        <p class="text-muted small mb-3">
                            <em>Resources owned by the business that have value and can generate income, such as cash,
                                inventory, and property.</em>
                        </p>
                        <ul class="list-group mb-3">
                            <li class="list-group-item d-flex justify-content-between">
                                <span>Cash / Bank</span>
                                <strong>{{ number_format($cash, 2) }}</strong>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span>Customer Debts (A/R)</span>
                                <strong>{{ number_format($customerDebts, 2) }}</strong>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span>Inventory</span>
                                <strong>{{ number_format($inventoryValue, 2) }}</strong>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span>Fixed Assets</span>
                                <strong>{{ number_format($fixedAssets, 2) }}</strong>
                            </li>
                            <li class="list-group-item d-flex justify-content-between bg-light">
                                <strong>Total Assets</strong>
                                <strong>{{ number_format($totalAssets, 2) }}</strong>
                            </li>
                        </ul>
                    </div>

                    {{-- ===== LIABILITIES & EQUITY ===== --}}
                    <div class="col-md-6">
                        <h5>Liabilities & Equity</h5>
                        <p class="text-muted small mb-3">
                            <em>Liabilities are what the business owes to others, while equity reflects the owners’ share
                                after settling all obligations. Together, they show how the assets are financed.</em>
                        </p>
                        <ul class="list-group mb-3">
                            <li class="list-group-item d-flex justify-content-between">
                                <span>Supplier Debts (A/P)</span>
                                <strong>{{ number_format($supplierDebts, 2) }}</strong>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <strong>Total Liabilities</strong>
                                <strong>{{ number_format($totalLiabilities, 2) }}</strong>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span>Retained Earnings (Net Profit)</span>
                                <strong>{{ number_format($netProfit, 2) }}</strong>
                            </li>
                            <li class="list-group-item d-flex justify-content-between bg-light">
                                <strong>Total Equity</strong>
                                <strong>{{ number_format($totalEquity, 2) }}</strong>
                            </li>
                            <li class="list-group-item d-flex justify-content-between bg-light">
                                <strong>Total Liabilities + Equity</strong>
                                <strong>{{ number_format($totalLiabilities + $totalEquity, 2) }}</strong>
                            </li>
                        </ul>
                    </div>
                </div>

                {{-- ===== BALANCE CHECK ===== --}}
                <div class="text-center mt-4">
                    @if ($balance == 0)
                        <h5 class="text-success">✅ Balanced</h5>
                        <p class="small text-muted">Total assets equal liabilities plus equity — balance sheet is accurate.
                        </p>
                    @else
                        <h5 class="text-danger">⚠️ Not Balanced (Difference: {{ number_format($balance, 2) }})</h5>
                        <p class="small text-muted">Review transactions — assets do not match liabilities plus equity.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const typeSelect = document.getElementById('type');
            const startField = document.getElementById('startField');
            const endField = document.getElementById('endField');

            function toggleDateFields() {
                if (typeSelect.value === 'custom') {
                    startField.style.display = 'block';
                    endField.style.display = 'block';
                } else {
                    startField.style.display = 'none';
                    endField.style.display = 'none';
                }
            }

            toggleDateFields();
            typeSelect.addEventListener('change', toggleDateFields);
        });
    </script>
@endsection
